{ *********************************************************************** }
{                                                                         }
{ Friends Telephone Drectory Demo                                         }
{                                                                         }
{ by Kris Golko                                                           }
{ Altair IV Ltd                                                           }
{                                                         London 2003     }
{ *********************************************************************** }

unit dmuTel;

interface

uses
  SysUtils, Classes, DBXpress, DB, SqlExpr, FMTBcd, DBClient, Provider,
  System.ComponentModel;

type
  TdmTel = class(TDataModule)
    SQLConnection: TSQLConnection;
    dtsFriends: TSQLDataSet;
    prvFriends: TDataSetProvider;
    cdsFriends: TClientDataSet;
    cdsFriendsFRIENDID: TIntegerField;
    cdsFriendsFIRSTNAME: TStringField;
    cdsFriendsLASTNAME: TStringField;
    cdsFriendsADDRESS: TStringField;
    cdsFriendsNAME: TStringField;
    dtsPhones: TSQLDataSet;
    dsFriends: TDataSource;
    cdsFriendsdtsPhones: TDataSetField;
    cdsPhones: TClientDataSet;
    dtsCategoryLookup: TSQLDataSet;
    prvCategoryLookup: TDataSetProvider;
    cdsCategoryLookup: TClientDataSet;
    cdsPhonesPHONEID: TIntegerField;
    cdsPhonesFRIENDID: TIntegerField;
    cdsPhonesCATEGORYID: TIntegerField;
    cdsPhonesPHONENUMBER: TStringField;
    cdsPhonesCATEGORY: TStringField;
    procedure cdsFriendsCalcFields(DataSet: TDataSet);
    procedure cdsFriendsReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
  private
    { Private declarations }
    procedure ShowConnectError(Msg: string);
  public
    { Public declarations }
    function Connect(DBPath: string): boolean;
    function NextFriendId: integer;
    function NextPhonesId: integer;
  end;

var
  dmTel: TdmTel;

implementation

uses
  Dialogs, frmuError;

{$R *.dfm}

const
  DB_FILENAME = 'Tel.ib';

procedure TdmTel.ShowConnectError(Msg: string);
var
  frmError: TfrmError;
begin
  frmError := TfrmError.Create(nil, Msg, SQLConnection.Params.Values['Database']);
  frmError.ShowModal;
  frmError.Free;
end;

function TdmTel.Connect(DBPath: string): boolean;
begin
  Result := false;
  try
    SQLConnection.Params.Values['Database'] := DBPath + DB_FILENAME;
    SQLConnection.Open;
    cdsFriends.Open;
    Result := true;
  except
    on E:Exception do
      ShowConnectError(E.Message);
  end;
end;

// It's mre efficient to generate a unique key value in a databse trigger
// but to use nested tables, you need to have the key value before ApplyUpdates
function TdmTel.NextFriendId: integer;
const
  SQL_NEXTFRIENDID = 'SELECT GEN_ID(GENFRIENDID, 1) from RDB$DATABASE';
var
  dtsTemp: TSQLDataSet;
begin
  dtsTemp := TSQLDataSet.Create(nil);
  dtsTemp.Close;  // just in case
  try
    dtsTemp.SQLConnection := SQLConnection;
    dtsTemp.CommandText := SQL_NEXTFRIENDID;
    dtsTemp.GetMetadata := false;
    dtsTemp.Open;
    Result := dtsTemp.Fields[0].AsInteger;
  finally
    dtsTemp.Free;
  end;
end;

function TdmTel.NextPhonesId: integer;
const
  SQL_NEXTPHONEID = 'SELECT GEN_ID(GENPHONEID, 1) from RDB$DATABASE';
var
  dtsTemp: TSQLDataSet;
begin
  dtsTemp := TSQLDataSet.Create(nil);
  dtsTemp.Close;  // just in case
  try
    dtsTemp.SQLConnection := SQLConnection;
    dtsTemp.CommandText := SQL_NEXTPHONEID;
    dtsTemp.GetMetadata := false;
    dtsTemp.Open;
    Result := dtsTemp.Fields[0].AsInteger;
  finally
    dtsTemp.Free;
  end;
end;

procedure TdmTel.cdsFriendsCalcFields(DataSet: TDataSet);
begin
  with DataSet do
  begin
    FieldByName('NAME').AsString :=
       FieldByName('LASTNAME').AsString + ', ' + FieldByName('FIRSTNAME').AsString;
  end;
end;

procedure TdmTel.cdsFriendsReconcileError(DataSet: TCustomClientDataSet;
  E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  MessageDlg(E.Message, mtError, [mbOk], 0);
  Action := raAbort;
end;

end.
